if (location.hostname.indexOf('.bbc.co.uk') != -1) {

    var edition = getCookie('BBCNewsAudience');
    var weighting = getCookie('BBCNewsAudcWght');

    if  (isValidEdition(edition)
         && (!weighting)) {
    
      // Get the main global variable out of the way
      var d = new Date();
      var MS_INIT_TIME = d.getTime(); 

      weighting =  -99;

      clearAudienceCookies();

      setAudienceCookie(edition);
      setWeightingCookie(weighting);

    }

}

function clearAudienceCookies() {

    // Ensuring that we've deleted the cookies on all relevant domains, 
    //   before trying to set new ones
    setRawCookie('BBCNewsAudience','0',gmtLastYear(),'/','bbc.co.uk');
    setRawCookie('BBCNewsAudience','0',gmtLastYear(),'/','.bbc.co.uk');

}

function setAudienceCookie(audience) {

    setRawCookie('BBCNewsAudience',audience,gmtInTwoYears(),'/','.bbc.co.uk');

}

function setWeightingCookie(weight) {

    setRawCookie('BBCNewsAudcWght',weight,gmtInTwoYears(),'/','.bbc.co.uk');

}

function setUpdateCookie() {

    setRawCookie('BBCNewsAudcWghtUpd',1,gmtInOneDay(),'/','.bbc.co.uk');

}

function gmtInTwoYears() {

    var msTwoYears =  1000*60*60*24*365*2;

    return gmtAfterMSTimeAfterInit(msTwoYears);

}

function gmtLastYear() {

    var msOneYearAgo = (-1)*1000*60*60*24*365;

    return gmtAfterMSTimeAfterInit(msOneYearAgo);

}

function gmtInOneDay() {

    var msOneDay =  1000*60*60*24;

    return gmtAfterMSTimeAfterInit(msOneDay);

}

function gmtAfterMSTimeAfterInit(msTimeInterval) {

    var dummyDate = new Date();
    dummyDate.setTime(MS_INIT_TIME + msTimeInterval);

    return dummyDate.toGMTString();

}


/**
 * Sets a Cookie with the given name and value.
 *
 * name       Name of the cookie
 * value      Value of the cookie
 * [expires]  Expiration date of the cookie (default: end of current session)
 * [path]     Path where the cookie is valid (default: path of calling document)
 * [domain]   Domain where the cookie is valid
 *              (default: domain of calling document)
 */
function setRawCookie(name, value, expires, path, domain) {

    document.cookie= name + "=" + escape(value) +
        ((expires) ? "; expires=" + expires : "") +
        ((path) ? "; path=" + path : "") +
        ((domain) ? "; domain=" + domain : "");
}

function getCookie(new_cookie) {

    var dc = document.cookie;

    var prefix = new_cookie + "=";

    var begin = dc.indexOf("; " + prefix);

    if (begin == -1) {

        begin = dc.indexOf(prefix);

        if (begin != 0) return null;

    } else {

        begin += 2;

    }

    var end = document.cookie.indexOf(";", begin);

    if (end == -1) {

        end = dc.length;

    }

    return unescape(dc.substring(begin + prefix.length, end));	

}

function domainForHostname(hostname) {

    var positionOfFirstDot = hostname.indexOf('.');

    var domain = hostname.substr(positionOfFirstDot);

    return domain;

}

function isValidEdition(edition) {

    if (edition == "Domestic")      { return 1; }
    if (edition == "International") { return 1; }

    return 0;

}



